#include <io16f876.h>
#include <inpic.h>

#pragma language=extended

const char katodRB[]=
    {0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00};
const char katodRC[]=
    {0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
const char katodRA = 0x08;

__no_init __eeprom unsigned char ekatod, eanod;
__no_init __eeprom unsigned char edpmode, emasodperc;
//__no_init __eeprom unsigned char edigitirany;
__no_init __eeprom unsigned char eadjust, enulla;



#define INTERRUPT_VECTOR 0x4 

#define key1     RA2
#define key2     RA1
#define key3     RA0
//#define out1     RC4
//#define out2     RC5

#define maxmenu     9;
#define mnulla      9;
#define mdigitirany 8;
#define mmasodperc  7;
#define mdpmode     6;
#define manod       5;
#define mkatod      4;
#define msec        3;
#define mmin        2;
#define mhour       1;

//#define locktime 60;

//#define dfdigitirany  0;
#define dfadjust     16;
#define dfmasodperc   1;
#define dfdpmode      3; // 0 = kettspont, pont sem vilgt; 1 = kettspont villog; 2 = pont villog; 3 = kettspont villog, pont vilgt; 4 = kettspont vilgt, pont villog
#define dfanod        1; // 0 = andvezrls aktv alacsony szint, 1 = andvezrls aktv magas szint
#define dfkatod       1; // 0 = katdvezrls aktv alacsony szint, 1 = katdvezrls aktv magas szint
#define dfnulla       1; // 0 = tzes ra kioltva, ha nulla, 1 = tzes rn megjelenik a nulla

__bank1 unsigned char BCD[6];
unsigned char bdigit, cdigit;
unsigned char a, b;
unsigned char h, m;
unsigned int clock_cnt;
//unsigned char adtimer;
unsigned char keytimer, muxtimer, muxe;
__bank1 unsigned char menucount;
__bank1 unsigned int dstmp;
//__bank1 unsigned int AD1ON1, AD1OFF1, AD1ON2, AD1OFF2;
//__bank1 unsigned int AD2ON1, AD2OFF1, AD2ON2, AD2OFF2;
//__bank1 unsigned int AD1ON, AD1OFF, AD2ON, AD2OFF;
//__bank1 unsigned char AD1OFS, AD2OFS;
__bank1 unsigned char katod, anod;
__bank1 unsigned char dpmode, masodperc, nulla;
//__bank1 unsigned char digitirany;
__bank1 unsigned int adjust;
//__bank1 unsigned char CLKH1, CLKH2;

union
{
 unsigned char s;
 struct
 {
  unsigned char s0:1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
 };
};

/*union
{
 unsigned char addata;
 struct 
 {
  unsigned char adint:1;
  unsigned char adshow:1;
  unsigned char ad0ctrl:1;
  unsigned char ad1ctrl:1;
  unsigned char ad0sel:1;
  unsigned char ad1sel:1;
  unsigned char adscan:1;
  unsigned char adgo:1;
 };
};*/ 
/*
union
{
 unsigned char leddata;
 struct 
 {
  unsigned char ledido1:1;
  unsigned char :1;
  unsigned char :1;
  unsigned char ledido2:1;
  unsigned char ledad2:1;
  unsigned char ledad1:1;
  unsigned char :1;
  unsigned char :1;
 };
};*/ 

union
{
 unsigned char lddata;
 struct
 {
  unsigned char dp1:1;
  unsigned char dp2:1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char showmenu:1;
  unsigned char clockshow:1;
  unsigned char clockshmode:1;
 };
};
 
union
{
 unsigned char keydata;
 struct
 {
  unsigned char key1press:1;
  unsigned char key2press:1;
  unsigned char key3press:1;
  unsigned char key1s:1;
  unsigned char key2s:1;
  unsigned char key3s:1;
  unsigned char :1;
  unsigned char ct:1;
 };
};

/*union
{
 unsigned char clklimitdata;
 struct
 {
  unsigned char ad1limit1:1;
  unsigned char ad1limit2:1;
  unsigned char ad2limit1:1;
  unsigned char ad2limit2:1;
  unsigned char tempset:1;
  unsigned char ad1valid:1;
  unsigned char ad2valid:1;
  unsigned char :1;
 };
};  
*/
/*union
{
 unsigned int adres;
 struct
 {
  unsigned char adres_h;
  unsigned char adres_l;
 };
};*/ 
/*
union
{
 unsigned int checktime1;
 struct
 {
  unsigned char check_h1;
  unsigned char check_m1;
 };
};  

__bank1 union
{
 unsigned int checktime2;
 struct
 {
  unsigned char check_h2;
  unsigned char check_m2;
 };
};  
*/

__bank1 union
{
 unsigned char ch1;
 struct
 {
  unsigned char chkatod:1;
  unsigned char chanod:1;
  unsigned char chdpmode:1;
  unsigned char chmasodperc:1;
//  unsigned char chdigitirany:1;
  unsigned char chadjust:1;
  unsigned char chnulla:1;
  unsigned char :1;
  unsigned char :1;
 };
};


/*
__bank1 union
{
 unsigned char ch2;
 struct
 {
  unsigned char chAD1OFS:1;
  unsigned char chAD2OFS:1;
  unsigned char chCLKH1:1;
  unsigned char chCLKH2:1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
 };
};
*/



//unsigned int adbuf[17];
//unsigned char adbufcnt;

//unsigned int adc1;
//unsigned int adc2;
//char szegmens = PORTB;
//#define digit    = PORTC;

//#define out1     = PORTC,4

void delay(unsigned int b)
{
 unsigned int a;
 
 for (a=0;a<b;a++) 
  {
  __no_operation(); 
  };

}


void multiplex(void)
{
 if (anod) PORTC &= 0xC0; // digitkijells trls, aktv magas szint esetn
  else PORTC |= 0x3F; // digitkijells trls, aktv alacsony szint esetn
 if (katod) PORTC &= 0x3F; // szegmenskijells trls, aktv magas
  else PORTC |= 0xC0; // szegmenskijells trls, aktv alacsony

 if (muxe<2){
  muxe++;
  return;
 }
 muxe=0;
 a=BCD[bdigit];
 if ((!(nulla)) && (!(showmenu)))
  if ((bdigit==5) && (a==0)) a = 10; // tzes ra 0 szmjegy nemkell
 b=0;
/* if (a!=0x16)
 { 
  a=segdec[a];
 } else a=leddata;
 */

 switch (bdigit)
 {
  case 2: if (dp1) b|= katodRA; break;
  case 4: if (dp2) b|= katodRA; break;
 };

 if (katod){ // szegmenskijells ".", aktv magas szint esetn
  PORTA&= 0xFF-katodRA;
  PORTA|= b; 
  } else { // aktv alacsony szint esetn
     PORTA|= katodRA;
     b^= 0xFF;
     PORTA&= b; 
    }
 b=0;
 b = katodRC[a];
 a = katodRB[a];
 
// a^= 0xFF; 
 if (katod) { // aktv magas
//  PORTC &= 0x3F; // szegmenskijells trls
  PORTC |= b; // szegmenskijells "0"-"1"
  PORTB = a; // szegmenskijells "2"-"9"
  } else { // aktv alacsony
//     PORTC |= 0xC0; // szegmenskijells trls
     b^= 0xFF;
     PORTC &= b; // szegmenskijells "0"-"1"
     a^= 0xFF;
     PORTB = a; // szegmenskijells "2"-"9"
    }
 
 
 a=1;
 a= a << bdigit;
 if (anod) PORTC|= a; // digitkijells, aktv magas
  else { // aktv alacsony
    a^= 0xFF;
    a&= 0x3F;
    PORTC&= a;
   }

  if (bdigit==5) 
  {
   if (!(showmenu)) {
    if (masodperc) bdigit = 0; // msodperc kijelzs kell
     else bdigit = 2; // nemkell
   } else bdigit = 0; 
  } else
   {
    bdigit++;
   } 
}

void step_clock(void)
{
 if (clock_cnt==(1937+adjust))  // 472+adjust, ha prescaler=8
  {
   clock_cnt= 0;
   if (s==59)
    {
     s= 0;
     if (m==59)
      {
       m= 0;
       if (h==23)
        {
         h= 0;
        } else h++;
      } else m++;
    } else s++;
  } else clock_cnt++;
}

/*void checkadstart(void)
{
 if (adtimer==200) // 200
  { 
   adtimer= 0;
   adgo= 1;
  } else adtimer++;
}
*/

void checkkeypress(void)
{
 if (keytimer==30) // 30
  { 
   keytimer= 0;
   if (key1) { key1s= 1; }
   if (key2) { key2s= 1; }
   if (key3) { key3s= 1; }
    
   if (!key1)
    {
     if (key1s) 
      {
       key1press= 1;
       key1s= 0;
      }
     } 

   if (!key2)
    {
     if (key2s) 
      {
       key2press= 1;
       key2s= 0;
      }
     } 

   if (!key3)
    {
     if (key3s) 
      {
       key3press= 1;
       key3s= 0;
      }
     } 

  } else keytimer++;
}


#pragma vector=INTERRUPT_VECTOR
__interrupt void intserv(void)
{
 if (T0IF) T0IF=0;
/* if (ADIF) 
  {
   ADIF= 0;
   adint= 1;
  } 
 */
 if (muxtimer==1){
   multiplex();
   muxtimer=0;
   } else muxtimer++;
 step_clock();
// checkadstart(); 
 checkkeypress();
}


void itobcd(unsigned int i, unsigned char d, unsigned char s)
{
 unsigned int ii;
 unsigned char ss;
 
// dd= d;
 ii= i;
 ss= 0;
 while (ii)
 {
  BCD[d]= ii % 10;
  ii/= 10;
  d++;
  ss++;
  if (ss==s) break;
 } 
 while (ss!=s)
  {
   BCD[d]= 0;
   d++;
   ss++;
  }
}


void readfrom(void)
{

 katod = ekatod;
 anod = eanod;
 dpmode = edpmode;
 masodperc = emasodperc;
 adjust = eadjust;
 nulla = enulla;
}


void writeto(void)
{
 unsigned char tp;
  
 BCD[4]= 0x09;
 BCD[5]= 0x09;
 tp= 1;
 itobcd(tp, 0, 2);
 if (chkatod)  
 {
  delay(30000);
  ekatod=  katod;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chanod)
 {
  delay(30000);
  eanod= anod;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chdpmode) 
 {
  delay(30000);
  edpmode=  dpmode;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chmasodperc)
 {
  delay(30000);
  emasodperc= masodperc;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chadjust) 
 {
  delay(30000);
  eadjust=  adjust;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chnulla) 
 {
  delay(30000);
  enulla=  nulla;
 }
 ch1= 0;
// ch2= 0;
}

void writeall(void)
{
 ch1= 0xFF;
// ch2= 0xFF;
 writeto();
}


void setdefaults(void)
{
 katod = dfkatod;
 anod = dfanod;
 dpmode =  dfdpmode;
 masodperc = dfmasodperc;
 adjust = dfadjust;
 nulla = dfnulla;
 writeall();
}

void display(void)
{
 if (!showmenu)
  {
//   dp3= 1;
   itobcd(m, 2, 2);
   itobcd(h, 4, 2);
   itobcd(s, 0, 2);
   switch (dpmode)
   {
    case 0: {
             dp1 = 0;
             dp2 = 0;
             break;
            } 
    case 1: {
             dp1 = 0;
             dp2 = !s0;
             break;
            } 
    case 2: {
             dp1 = !s0;
             dp2 = 0;
             break;
            } 
    case 3: {
             dp1 = 1;
             dp2 = !s0;
             break;
            } 
    case 4: {
             dp1 = !s0;
             dp2 = 1;
             break;
            } 
    
   }
 } else {
         if (menucount==7) dstmp = s;
         itobcd(dstmp, 2, 2);
        }
}

void key1handler(void)
{
 if (menucount==0)
  {
   menucount= 9;
   showmenu= 1;
   dp1= 0;
   dp2= 1;
   BCD[0]= 0x0A;
   BCD[1]= 0x0A;  
//   dp3= 0;
   
  } else menucount--;

 switch (menucount)
 {
  case 9: {
                 BCD[5]= 0x00;
                 BCD[4]= 0x01;  
                 dstmp= h;
                 break;
                }
  case 8:{
                 BCD[5]= 0x00;
                 BCD[4]= 0x02;  
                 dstmp= m;
                 break;
                }
  case 7: {
                 BCD[5]= 0x00;
                 BCD[4]= 0x03;  
                 dstmp= s;
                 break;
                }
  case 6: {
                 BCD[5]= 0x00;
                 BCD[4]= 0x04;  
                 dstmp= katod;
                 break;
                }
  case 5:  {
                 BCD[5]= 0x00;
                 BCD[4]= 0x05;  
                 dstmp= anod;
                 break;
                }
  case 4:  {
                 BCD[5]= 0x00;
                 BCD[4]= 0x06;  
                 dstmp= dpmode;
                 break;
                }
  case 3:   {
                 BCD[5]= 0x00;
                 BCD[4]= 0x07;  
                 dstmp= masodperc;
                 break;
                }
  case 2:    {
                 BCD[5]= 0x00;
                 BCD[4]= 0x08;  
                 dstmp= adjust;
                 break;
                }
  case 1:    {
                 BCD[5]= 0x00;
                 BCD[4]= 0x09;  
                 dstmp= nulla;
                 break;
                }
 };
// menucount--;  
 if (menucount==0)
 {
  showmenu = 0;
  writeto();
 } 
}

void key2handler(void)
{
 if (!showmenu)
 {
  if (clockshow)
  {
   clockshmode= !clockshmode;
  } else
    {
//     adshow= !adshow;
//     ledad2= !ledad2;
//     ledad1= !ledad1;
    }
 } else
   {
 switch (menucount)
 {
  case 9: {     if (h>0) h--;
                 dstmp = h;
                 break;
                }
  case 8:{      if (m>0) m--;
                 dstmp = m;
                 break;
                }
  case 7: {     
                 break;
                }
  case 6: {     if (katod>0) katod--;
                 chkatod= 1;
                 dstmp= katod;
                 break;
                }
  case 5:  {     if (anod>0) anod--;
                 chanod= 1;
                 dstmp= anod;
                 break;
                }
  case 4:  {     if (dpmode>0) dpmode--;
                 chdpmode= 1;
                 dstmp= dpmode;
                 break;
                }
  case 3:   {     if (masodperc>0) masodperc--;
                 chmasodperc= 1;
                 dstmp= masodperc;
                 break;
                }
  case 2:    {   if (adjust>1) adjust--; 
                 clock_cnt = 0;
                 chadjust= 1;
                 dstmp= adjust;
                 break;
                }
  case 1:   {     if (nulla>0) nulla--;
                 chnulla= 1;
                 dstmp= nulla;
                 break;
                }
 };
   }
}

void key3handler(void)
{
 if (!showmenu)
 {
  clockshow= !clockshow;
 } else
    {
 switch (menucount)
 {
  case 9: {     if (h<23) h++;
                 dstmp= h;
                 break;
                }
  case 8:{     if (m<59) m++;
                 dstmp= m;
                 break;
                }
  case 7: {      s = 0;
                 clock_cnt= 0;
                 dstmp= s;
                 break;
                }
  case 6: {     if (katod<1) katod++;
                 chkatod= 1;
                 dstmp= katod;
                 break;
                }
  case 5:  {     if (anod<1) anod++;
                 chanod= 1;
                 dstmp= anod;
                 break;
                }
  case 4:  {     if (dpmode<4) dpmode++;
                 chdpmode= 1;
                 dstmp= dpmode;
                 break;
                }
  case 3:   {    if (masodperc<1) masodperc++;
                 chmasodperc= 1;
                 dstmp= masodperc;
                 break;
                }
  case 2:    {   if (adjust<31) adjust++; 
                 clock_cnt = 0;
                 chadjust= 1;
                 dstmp= adjust;
                 break;
                }
  case 1:   {    if (nulla<1) nulla++;
                 chnulla= 1;
                 dstmp= nulla;
                 break;
                }
 };
  } 
}

void keyhandler(void)
{
 if (key1press)
 {
  key1press= 0;
  key1handler();
 }
 if (key2press)
 {
  key2press= 0;
  key2handler();
 }
 if (key3press)
 {
  key3press= 0;
  key3handler();
 }
}

void main(void)
{
__set_configuration_word(0x3F7A);

 // init
 TRISC=0;
 TRISB=0;
 OPTION=0; // 2, ha prescaler=8
 ADCON1=0x07;
 PORTB=0;
 PORTC=0;
 bdigit=0;
 cdigit=0;
 TMR0=0;
 // setup interrupt routine
// ADIE=1;
 EEIE=0;
// ADCON0=129;
// ADIF=0;
 PEIE=1;
// adtimer= 0;
 keytimer= 0;
 muxtimer=0;
 muxe=0;
// adscan= 0;
 menucount= 0;
// ad1valid= 0;
// ad2valid= 0;
// for (adbufcnt=0;adbufcnt!=17;adbufcnt++)
//   adbuf[adbufcnt]= 0;
  
// adbufcnt= 1;
 h= 0;
 m= 0;
 s= 0;
 clock_cnt= 0;  
 TRISA= 0x37;
// TRISC&= 0xCF;
 
 BCD[0]=0x00;
 BCD[1]=0x00;
 BCD[2]=0x00;
 BCD[3]=0x00;
 BCD[4]=0x00;
 BCD[5]=0x00;
// setdefaults();
 if (!key2) 
 {
  while (!key2) ;
  T0IE=1;
  GIE=1;
  delay(40000);
  setdefaults();
  BCD[0]=0x08;
  BCD[1]=0x08;
  BCD[2]=0x08;
  BCD[3]=0x08;
  BCD[4]=0x08;
  BCD[5]=0x08;
  delay(50000);
 } else readfrom();
 //enable interrupt
 T0IE=1;
 GIE=1;

// adshow= 1;
 clockshmode= 1;
 clockshow= 1;
 showmenu= 0;
// showad= 1;
  
// startad();
 
 while (1)
 {
  keyhandler();
  display();  
/*  if (adint) 
   {
    getad();
    adint= 0;
   }

  if (adgo)
   { 
    startad();
   }*/
 }

}


